<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:include href="Filter%20Settings.xslt"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/filterSettings.css" media="screen,print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/tag_cloud.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/zero_states.css" media="all" charset="utf-8" type="text/css" />
		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/tagCloud.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/filterSettings.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>
		<script type="text/javascript">
$(TagCloudInit);
		</script>
	</head>
	<body id="tagCloud">
		<div id="outerWrapper">
			<div id="innerWrapper" class="fullWidth">
                <div class="time_frame_select_div">
                    <select id="timeFrameSelect">
                        <option value="0">Sort by Name</option>
                        <option value="1">Sort by Frequency</option>
                        <option value="2">Sort by Money Spent</option>
                    </select>
                    <div class="select_arrow_wrapper">
                        <div class="arrow_up"></div>
                        <div class="arrow_down"></div>
                    </div>
                </div>

				<xsl:apply-templates select="filterSettings"/>
				<div class="tagCloudCont">
					
					<!-- Adding test for no results state -jp -->
					<xsl:choose>
						<!-- Do we have any items? -->
						<xsl:when test="count(cloudSlice)">						
							<xsl:for-each select="cloudSlice">
								<xsl:call-template name="cloudSliceAnchor"/>
							</xsl:for-each>
							<xsl:for-each select="cloudSlice">
								<xsl:call-template name="cloudSliceMeta"/>
							</xsl:for-each>
						</xsl:when>
								
						<!-- No items -->
						<xsl:otherwise>
								<xsl:call-template name="cloudSliceNone"/>
						</xsl:otherwise>
					</xsl:choose>					

				</div>
			</div>
		</div>
	</body>
	</html>
</xsl:template>

<xsl:template name="cloudSliceAnchor">
	<a href="#" class="font{@bucket}" title="" quickenids="{quickenIDs}" id="category_{@name}"><xsl:value-of select="@name"/></a>
	<xsl:text> </xsl:text>
</xsl:template>


<xsl:template name="cloudSliceMeta">
	<div class="tagMeta" id="popover_{@name}">
		<div class="rawUseCount" id="usageCount_{@name}"><xsl:value-of select="@useCount"/></div>
		<div class="rawTotal" id="total_{@name}"><xsl:value-of select="@rawTotal"/></div>
		<span><strong>
			<xsl:choose>
				<xsl:when test="@useCount > 1"><xsl:value-of select="@useCount"/> Transactions</xsl:when>
				<xsl:otherwise>1 Transaction</xsl:otherwise>
			</xsl:choose>
		</strong></span><br />
		<span><strong><xsl:value-of select="total"/> total</strong></span>
		<div class="tagMetaPointer"></div>
	</div>
</xsl:template>


<!-- No results for the given filter range -->

<xsl:template name="cloudSliceNone">
<div class="zeroState">
	<div class="noDataA">
		<p class="first">You have no transactions for the selected settings.</p>
		<p class="second">Try updating your settings above.</p>
	</div>	
</div>
</xsl:template>




</xsl:stylesheet>
